namespace gov.va.med.vbecs.DAL.HL7.OpenLibrary
{
	/// <summary>
	/// CR 2962
	/// </summary>
	public enum AckCodes
	{
		/// <summary>
		/// Application Error
		/// </summary>
		AE,
		/// <summary>
		/// Application Reject
		/// </summary>
		AR,
		/// <summary>
		/// Application Accept
		/// </summary>
		AA
	}

	/// <summary>
	/// CR 2962
	/// </summary>
	public enum AckErrorCodes
	{
		/// <summary>
		/// MessageAccepted
		/// </summary>
		MessageAccepted = 0,
		/// <summary>
		/// SegmentSequenceError
		/// </summary>
		SegmentSequenceError = 100,
		/// <summary>
		/// RequiredFieldMissing
		/// </summary>
		RequiredFieldMissing = 101,
		/// <summary>
		/// DataTypeError
		/// </summary>
		DataTypeError = 102,	
		/// <summary>
		/// TableValueNotFound
		/// </summary>
		TableValueNotFound = 103,
		/// <summary>
		/// UnsupportedMessageType
		/// </summary>
		UnsupportedMessageType = 200,
		/// <summary>
		/// UnsupportedEventCode
		/// </summary>
		UnsupportedEventCode = 201,
		/// <summary>
		/// UnsupportedProcessingId
		/// </summary>
		UnsupportedProcessingId = 202,
		/// <summary>
		/// UnsupportedVersionId
		/// </summary>
		UnsupportedVersionId = 203,
		/// <summary>
		/// UnknownKeyIdentifier
		/// </summary>
		UnknownKeyIdentifier = 204,
		/// <summary>
		/// DuplicateKeyIdentifier
		/// </summary>
		DuplicateKeyIdentifier = 205,
		/// <summary>
		/// ApplicationRecordLocked
		/// </summary>
		ApplicationRecordLocked = 206,
		/// <summary>
		/// ApplicationInternalError
		/// </summary>
		ApplicationInternalError = 207,
        /// <summary>
        /// ConflictingProcessingId CR 3243
        /// </summary>
        ConflictingProcessingId = 208,
	}

	/// <summary>
	/// 
	/// </summary>
	public enum AckErrorSeverity
	{
		/// <summary>
		/// Error
		/// </summary>
		Error = 0,
		/// <summary>
		/// Information
		/// </summary>
		Information = 1,
		/// <summary>
		/// Warning
		/// </summary>
		Warning = 2
	}

	/// <summary>
	/// 
	/// </summary>
	public enum AckTypes
	{
		/// <summary>
		/// Always
		/// </summary>
		AL,
		/// <summary>
		/// Never
		/// </summary>
		NE,
		/// <summary>
		/// Error/reject conditions only
		/// </summary>
		ER,
		/// <summary>
		/// Successful completion only
		/// </summary>
		SU
	}

	/// <summary>
	/// CR 2985
	/// </summary>
	public enum BloodProductCommentType
	{
		/// <summary>
		/// The barcode reader manual scan reason.
		/// This comment will be provided when the blood unit's id cannot be scanned.
		/// The value in the HL7 message will be 'VA-BCR'.
		/// </summary>
		Barcode,
		/// <summary>
		/// This field identifies the comment as the free-text transfusion note.
		/// The value in the HL7 message will be 'RE'.
		/// </summary>
		FreeText,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	}

	/// <summary>
	/// CR 2985
	/// </summary>
	public enum BloodProductMessageStatus
	{
		/// <summary>
		/// Final status; Can only be changed with a corrected status
		/// </summary>
		Final,
		/// <summary>
		/// Preliminary status
		/// </summary>
		Preliminary,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	}

	/// <summary>
	/// CR 2985
	/// </summary>
	public enum BloodProductTransfusionStatus
	{
		/// <summary>
		/// Returned unused/no longer needed
		/// </summary>
		RA,
		/// <summary>
		/// Returned unused/keep linked to patient for possible use later
		/// </summary>
		RL,
		/// <summary>
		/// Transfused with adverse reaction
		/// </summary>
		TR,
		/// <summary>
		/// Transfused
		/// </summary>
		TX,
		/// <summary>
		/// Wasted (product no longer viable)
		/// </summary>
		WA,
		/// <summary>
		/// Unknown
		/// </summary>
		UK
	}

	/// <summary>
	/// 
	/// </summary>
	public enum OrderControlCodes
	{
		/// <summary>
		/// Order/Service accepted and OK
		/// </summary>
		OK,
		/// <summary>
		/// Canceled as Requested
		/// </summary>
		CR,
		/// <summary>
		/// Unable to Cancel
		/// </summary>
		UC,
		/// <summary>
		/// New Order
		/// </summary>
		NW,
		/// <summary>
		/// Canceled or Deleted
		/// </summary>
		CA,
		/// <summary>
		/// Order/Service canceled
		/// </summary>
		OC,
		/// <summary>
		/// Status Changed
		/// </summary>
		SC,
		/// <summary>
		/// Previous Results
		/// </summary>
		PR,
		/// <summary>
		/// Unable to Accept
		/// </summary>
		UA
	}

	/// <summary>
	/// 
	/// </summary>
	public enum SegmentTypeNames
	{
		/// <summary>
		/// BPO
		/// </summary>
		BPO,
		/// <summary>
		/// BPX
		/// </summary>
		BPX,
		/// <summary>
		/// BTX
		/// </summary>
		BTX,
		/// <summary>
		/// DG1
		/// </summary>
		DG1,
		/// <summary>
		/// ERR
		/// </summary>
		ERR,
		/// <summary>
		/// EVN
		/// </summary>
		EVN,
		/// <summary>
		/// MRG
		/// </summary>
		MRG,
		/// <summary>
		/// MSA
		/// </summary>
		MSA,
		/// <summary>
		/// MSH
		/// </summary>
		MSH,
		/// <summary>
		/// NTE
		/// </summary>
		NTE,
		/// <summary>
		/// OBR
		/// </summary>
		OBR,
		/// <summary>
		/// OBX
		/// </summary>
		OBX,
		/// <summary>
		/// ORC
		/// </summary>
		ORC,
		/// <summary>
		/// PD1
		/// </summary>
		PD1,
		/// <summary>
		/// PID
		/// </summary>
		PID,
		/// <summary>
		/// PV1
		/// </summary>
		PV1,
		/// <summary>
		/// ZFF
		/// </summary>
		ZFF
	}

    /// <summary>
    /// 
    /// </summary>
    public enum ObservationResultStatus
    {
        /// <summary>
        /// 
        /// </summary>
        Correction,
        /// <summary>
        /// 
        /// </summary>
        Delete,
        /// <summary>
        /// 
        /// </summary>
        Final,
        /// <summary>
        /// 
        /// </summary>
        SpecimenInLab,
        /// <summary>
        /// 
        /// </summary>
        NotAsked,
        /// <summary>
        /// 
        /// </summary>
        DescriptionOnly,
        /// <summary>
        /// 
        /// </summary>
        PreliminaryResults,
        /// <summary>
        /// 
        /// </summary>
        ResultsEntered,
        /// <summary>
        /// 
        /// </summary>
        PartialResults,
        /// <summary>
        /// 
        /// </summary>
        ResultCannotBeObtained,
        /// <summary>
        /// 
        /// </summary>
        ResultsStatusChangeToFinal,
        /// <summary>
        /// 
        /// </summary>
        PostOriginalAsWrong,
        /// <summary>
        /// 
        /// </summary>
        Unknown
    }

}
